
local setname, coremajor = "Tradeskill", "1"
local vmajor, vminor = "Tradeskill 1", tonumber(string.sub("$Revision: 18601 $", 12, -3))


-- Check to see if an update is needed
-- if not then just return out now before we do anything
if not TekLibStub or not PeriodicTableEmbed or not PeriodicTableEmbed:NeedsUpgraded(vmajor, vminor) then return end

local mem = gcinfo()
local t = {

	-- Crafts required to create items
	-- Value == skill required in the respective tradeskill
	craftedby = {"craftedbyalchemy", "craftedbyblacksmith", "craftedbyengineering", "craftedbyleatherworking", "craftedbytayloring", "craftedbycooking", "craftedbyfirstaid"},
	craftedbyspecialty = {"craftedbytayloring", "craftedbyleatherworkinggeneral", "craftedbyleatherworkingdragonscale", "craftedbyleatherworkingelemental", "craftedbyleatherworkingtribal", "craftedbyfirstaid", "craftedbyengineeringgeneral", "craftedbyengineeringgnome", "craftedbyengineeringgoblin", "craftedbycooking", "craftedbyalchemy", "craftedbyblacksmithgeneral", "craftedbyarmorsmith", "craftedbyaxesmith", "craftedbyhammersmith", "craftedbyswordsmith", "craftedbyweaponsmith"},

	craftedbyalchemy = "118:1 858:55 929:110 1710:155 2454:1 2455:25 2456:40 2457:50 2458:50 2459:60 3382:15 3383:90 3384:110 3385:120 3386:120 3387:250 3388:125 3389:130 3390:140 3391:150 3577:225 3823:165 3824:165 3825:175 3826:180 3827:160 3828:195 3829:200 3928:215 4263:215 4596:50 5631:60 5633:175 5634:150 5996:90 5997:1 6037:225 6048:135 6049:165 6050:190 6051:100 6052:190 6149:205 6370:80 6371:130 6372:100 6373:140 6662:90 7068:300 7076:275 7078:275 7080:275 7082:275 8949:185 8951:195 8956:205 9030:215 9036:210 9061:210 9088:240 9144:225 9149:225 9154:230 9155:235 9172:235 9179:235 9187:240 9197:240 9206:245 9210:245 9224:250 9233:250 9264:250 10592:200 12190:230 12360:275 12803:275 12808:275 13423:250 13442:255 13443:260 13444:295 13445:265 13446:275 13447:270 13452:280 13453:275 13454:285 13455:280 13456:290 13457:290 13458:290 13459:290 13461:290 13462:285 13506:300 13510:300 13511:300 13512:300 13513:300 17708:190 18253:300 18294:215 19931:300 20002:275 20004:290 20007:275 20008:285 21546:250",

	craftedbyblacksmith = {"craftedbyblacksmithgeneral", "craftedbyarmorsmith", "craftedbyaxesmith", "craftedbyhammersmith", "craftedbyswordsmith", "craftedbyweaponsmith"},
	craftedbyblacksmithgeneral = "2844:15 2845:20 2847:25 2848:110 2849:115 2850:120 2851:35 2852:1 2853:1 2854:90 2857:91 2862:1 2863:65 2864:80 2865:105 2866:105 2868:120 2869:130 2870:145 2871:125 3239:1 3240:65 3241:125 3469:20 3470:25 3471:35 3472:40 3473:45 3474:60 3478:75 3480:110 3481:125 3482:130 3483:135 3484:145 3485:150 3486:125 3487:95 3488:35 3489:91 3490:125 3491:130 3492:145 3835:165 3836:170 3837:190 3840:160 3841:175 3842:155 3843:170 3844:180 3845:195 3846:185 3847:200 3848:100 3849:160 3850:175 3851:155 3852:170 3853:180 3854:200 3855:185 3856:200 5540:115 5541:140 6040:185 6041:190 6042:150 6043:165 6214:65 6338:100 6350:95 6731:100 7071:150 7166:30 7913:160 7914:160 7915:175 7916:180 7917:185 7918:205 7919:205 7920:210 7921:210 7922:215 7924:215 7926:220 7927:220 7928:225 7929 7930:230 7931:230 7932:235 7933:235 7934:245 7935 7936 7937:245 7941:210 7942:220 7943:225 7944:240 7945:230 7946:245 7947:255 7955:30 7956:125 7957:130 7958:135 7963:200 7964:200 7965:200 7966:200 7967:215 7969:235 9060:200 9366:205 10421:1 10423:155 11128:150 11144:200 11605:275 11606:270 12259:180 12260:190 12404:250 12405:250 12406:250 12408:255 12409:280 12410:280 12414:300 12415:270 12416:260 12417:295 12418:285 12419:290 12420:300 12422:300 12424:265 12425:270 12426:295 12427:295 12428:265 12429:300 12610:300 12611:300 12612:300 12613:300 12614:300 12643:250 12644:250 12645:275 12773:275 12775:280 12792:290 15869:100 15870:150 15871:200 15872:275 16206:275 17193:300 17704:190 18262:300 19043:290 19048:300 19051:290 19057:300 19690:300 19691:300 19692:300 19693:300 19694:300 19695:300 20549:300 20550:300 20551:300 22191:300 22194:300 22195:300 22196:300 22197:300 22198:300 22669:300 22670:300 22671:300 22762:300 22763:300 22764:300",
	craftedbyarmorsmith = "7938:225 7939:245 11604:285 12618:300 12619:300 12620:300 12624:270 12628:285 12631:290 12632:295 12633:300 12636:300 12639:300 12640:300 12641:300 16988:300 16989:295 17013:300 17014:295 19148:300 19164:300 20039:300 22385:300",
	craftedbyaxesmith = "12774:275 12784:300 12798:300 17016:300 19169:300",
	craftedbyhammersmith = "12776:280 12781:285 12794:300 12796:300 19170:300 22384:300",
	craftedbyswordsmith = "12777:280 12782:290 12790:300 12797:300 17015:300 19168:300 22383:300",
	craftedbyweaponsmith = "7954:235 7959:250 7960:260 7961:245 11607:280 11608:265 12783:300 19166:300 19167:300",

	craftedbycooking = "724:50 733:75 787:1 1017:100 1082:100 2679:1 2680:10 2681:1 2682:85 2683:75 2684:50 2685:110 2687:80 2888:25 3220:60 3662:80 3663:90 3664:120 3665:130 3666:110 3726:110 3727:125 3728:150 3729:175 4457:175 4592:50 4593:100 4594:175 5095:50 5472:10 5473:20 5474:35 5476:50 5477:50 5478:90 5479:100 5480:110 5525:50 5526:90 5527:125 6038:175 6290:1 6316:50 6657:85 6887:225 6888:1 6890:40 7676:60 8364:175 10841:175 12209:125 12210:175 12212:175 12213:175 12214:175 12215:200 12216:225 12217:200 12218:225 12224:1 13851:175 13927:225 13928:240 13929:240 13930:225 13931:250 13932:250 13933:275 13934:275 13935:275 16766:225 17197:1 17198:35 17222:200 18045:225 18254:275 20074:150 20452:285 21023:300 21072:80 21217:175",

	craftedbyengineering = {"craftedbyengineeringgeneral", "craftedbyengineeringgnome", "craftedbyengineeringgoblin"},
	craftedbyengineeringgeneral = "4357:1 4358:1 4359:30 4360:30 4361:50 4362:50 4363:65 4364:75 4365:75 4366:85 4367:100 4368:100 4369:105 4370:105 4371:105 4372:120 4373:120 4374:120 4375:125 4376:125 4377:125 4378:125 4379:130 4380:140 4381:140 4382:145 4383:145 4384:150 4385:150 4386:155 4387:160 4388:160 4389:170 4390:175 4391:175 4392:185 4393:185 4394:190 4395:195 4396:200 4397:200 4398:200 4401:75 4403:165 4404:90 4405:60 4406:110 4407:180 4852:185 5507:135 6219:50 6533:150 6712:100 6714:100 7148:165 7189:225 7506:125 8067:1 8068:75 8069:125 9312:150 9313:150 9318:150 10498:175 10499:175 10500:205 10501:220 10502:225 10503:230 10504:245 10505:175 10506:230 10507:175 10508:205 10510:220 10512:210 10513:245 10514:215 10518:225 10546:210 10548:240 10558:150 10559:195 10560:200 10561:215 10562:235 10576:250 10713 11590:200 15846:250 15992:250 15993:260 15994:260 15995:260 15996:265 15997:285 15999:270 16000:275 16004:275 16005:285 16006:285 16007:300 16008:290 16009:290 16022:300 16023:275 16040:300 17716:190 18168:300 18232:300 18282:300 18283:300 18588:200 18594:275 18631:260 18634:260 18637:275 18638:290 18639:300 18641:250 19026:250 19998:300 19999:300 21277 21557:125 21558:125 21559:125 21569:225 21570:275 21571:225 21574:225 21576:225 21589:175 21590:175 21592:175 21714:275 21716:275 21718:275",
	craftedbyengineeringgnome = "10545:210 10645:240 10716:205 10720:210 10721:215 10724:225 10725:230 10726:235 11826:205 18645:265 18660:260 18986",
	craftedbyengineeringgoblin = "10542:205 10543:205 10577:205 10586:235 10587:230 10588:245 10644:205 10646:205 10727:240 11825:205 18587:265 18984",

	craftedbyfirstaid = "1251:1 2581:40 3530:80 3531:115 6450:150 6451:180 6452:80 6453:130 8544:210 8545:240 14529:260 14530:290 19440:300",

	craftedbyleatherworking = {"craftedbyleatherworkinggeneral", "craftedbyleatherworkingdragonscale", "craftedbyleatherworkingelemental", "craftedbyleatherworkingtribal"},
	craftedbyleatherworkinggeneral = "18258 7281:91 2300:40 2302:25 2303:15 2304:1 2307:90 2308:85 2309:55 2310:60 2311:60 2312:75 2313:100 2314:120 2315:100 2316:110 2317:100 2318:1 2319:100 3719:150 4231:35 4233:100 4234:150 4236:150 4239:55 4242:75 4243:85 4244:100 4246:80 4247:145 4248:120 4249:125 4250:120 4251:130 4252:140 4253:135 4254:150 4255:155 4256:175 4257:160 4258:170 4259:180 4260:195 4262:185 4264:200 4265:150 4304:200 4327:200 4455:165 4456:165 5081:40 5739:190 5780:90 5781:95 5782:170 5783:190 5957:1 5958:105 5961:115 5962:160 5963:170 5964:170 5965:185 5966:190 6466:90 6467:105 6468:115 6709:90 7276:1 7277:1 7278:30 7279:30 7280:35 7282:95 7283:100 7284:120 7285:120 7348:125 7349:135 7352:135 7358:140 7359:145 7371:150 7372:150 7373:165 7374:175 7375:175 7377:180 7378:185 7386:190 7387:195 7390:200 7391:200 8170:250 8172:200 8173:200 8174:200 8175:205 8176:205 8185:235 8187:205 8189:210 8191:230 8192:210 8193:230 8197:235 8198:210 8200:215 8201:220 8202:240 8203:220 8204:225 8205:220 8206:245 8207:240 8208:250 8209:235 8210:220 8211:225 8212:250 8213:245 8214:225 8215:250 8216:240 8217:225 8218:225 15076:265 15077:255 15078:275 15079:285 15080:295 15081:300 15082:280 15083:260 15084:265 15085:300 15086:280 15087:290 15088:300 15090:300 15091:270 15092:275 15093:280 15094:290 15095:300 15096:300 15138:300 15407:250 15564:250 17721:190 18238:200 18251:300 18504:300 18506:300 18508:300 18662:150 18948:155 19044:290 19049:300 19052:290 19058:300 19149:300 19685:300 19686:300 19687:300 19688:300 19689:300 20476:300 20477:300 20478:300 20479:300 20480:300 20481:300 20575:100 22661:300 22662:300 22663:300 22664:300 22665:300 22666:300 22759:300 22760:300 22761:300",
	craftedbyleatherworkingdragonscale = "8347:225 8367:255 15045:260 15046:270 15047:300 15048:285 15049:295 15050:290 15051:300 15052:300 16984:300 18509:300 19157:300 20295:300 20296:280 20380:300",
	craftedbyleatherworkingelemental = "8346:230 8348:250 15053:285 15054:270 15055:300 15056:285 15057:275 15058:295 15059:300 15060:285 15061:270 16983:300 18511:300 19163:300 21278:300",
	craftedbyleatherworkingtribal = "8345:225 8349:250 15062:300 15063:290 15064:275 15065:285 15066:290 15067:270 15068:300 15069:285 15070:295 15071:275 15072:280 15073:275 15074:265 15075:290 16982:295 18510:300 19162:300",

	craftedbytayloring = "18258 2568:10 2569:65 2570:1 2572:40 2575:40 2576:1 2577:40 2578:91 2579:91 2580:60 2582:85 2583:95 2584:75 2585:105 2587:100 2996:1 2997:75 4238:45 4240:80 4241:95 4245:150 4305:125 4307:35 4308:60 4309:91 4310:85 4311:100 4312:80 4313:95 4314:110 4315:120 4316:110 4317:125 4318:130 4319:175 4320:125 4321:140 4322:165 4323:170 4324:150 4325:175 4326:185 4327:200 4328:180 4329:200 4330:110 4331:125 4332:135 4333:155 4334:170 4335:185 4336:200 4339:175 4343:30 4344:1 5542:90 5762:70 5763:115 5764:175 5765:185 5766:135 5770:150 6238:30 6239:55 6240:55 6241:30 6242:70 6263:100 6264:115 6384:120 6385:120 6786:40 6787:110 6795:160 6796:175 7026:15 7046:140 7047:145 7048:145 7049:150 7050:160 7051:170 7052:175 7053:175 7054:190 7055:175 7056:180 7057:180 7058:185 7059:190 7060:190 7061:195 7062:195 7063:205 7064:210 7065:165 9998:205 9999:205 10001:210 10002:210 10003:215 10004:215 10007:215 10008:215 10009:215 10018:225 10019:225 10021:225 10023:225 10024:230 10025:245 10026:230 10027:230 10028:235 10029:235 10030:240 10031:240 10033:240 10034:240 10035:245 10036:250 10040:250 10041:250 10042:225 10044:245 10045:1 10046:20 10047:75 10048:120 10050:225 10051:235 10052:220 10053:235 10054:230 10055:235 10056:215 13856:255 13857:260 13858:260 13860:265 13863:275 13864:280 13865:285 13866:295 13867:300 13868:255 13869:255 13870:265 13871:280 14042:260 14043:270 14044:275 14045:280 14046:260 14048:250 14100:270 14101:270 14103:275 14104:290 14106:300 14107:275 14108:285 14111:290 14112:300 14128:300 14130:300 14132:275 14134:275 14136:285 14137:290 14138:300 14139:300 14140:300 14141:275 14142:270 14143:265 14144:290 14146:300 14152:300 14153:300 14154:300 14155:300 14156:300 14342:250 15802:300 16979:300 16980:300 17723:190 18263:300 18405:300 18407:300 18408:300 18409:300 18413:300 18486:300 19047:290 19050:300 19056:290 19059:300 19156:300 19165:300 19682:300 19683:300 19684:300 20537:300 20538:300 20539:300 21154:250 21340:260 21341:285 21342:300 21542:250 22246:225 22248:275 22249:300 22251:275 22252:300 22652:300 22654:300 22655:300 22658:300 22660:300 22756:300 22757:300 22758:300",

	-- Items harvested by tradeskills
	gatherskill           = {"gatherskillfishing", "gatherskilldisenchant", "gatherskillherbalism", "gatherskillmining", "gatherskillskinning"},
	gatherskillfishing    = "13760 6291 13893 6303 13754 13755 13422 6362 6308 13888 6289 6359 6522 13758 6358 6317 13759 8365 13889 4603 13756 6361",
	gatherskilldisenchant = "20725 11083 16204 11137 11176 10940 11174 10938 11135 11175 16202 11134 16203 10998 11082 10939 11084 14343 11139 10978 11177 14344 11138 11178",
	gatherskillherbalism  = "3358 8839 13466 4625 13467 3821 785 13465 13468 2450 2452 3818 3355 3357 8838 3369 3820 8153 8836 13463 8845 8846 13464 2447 2449 765 2453 3819 3356 8831",
	gatherskillmining     = "7911 12799 1210 2775 774 12361 2776 12364 12365 3864 18562 2770 2771 3858 19774 11370 2835 12363 9262 1705 818 12800 2836 11382 7909 10620 11754 1206 7910 1529 7912 2838 2772",
	gatherskillskinning   = "15412 7392 2318 15414 15415 8165 15416 15417 2319 15419 8167 2934 7286 15422 15423 8169 8368 12810 8154 8170 6470 4234 19767 19768 4235 783 17012 4232 15408 8171 6471 5082 4461 7287 4304 7428",

	-- Tradeskill ingreds by type
	ingredbar      = "12359 11371 3860 2842 6037 3859 3575 2840 2841 3576 12655 3577 12360",
	ingredbolt     = "4305 2997 14048 4339 2996",
	ingredcloth    = "4306 14047 4338 14342 2592 14256 2589",
	ingreddust     = "11083 16204 11137 11176 10940",
	ingreddye      = "2325 2604 6260 6261 4342 10290 4340 2605 2324 4341 9210",
	ingredelement  = "7070 12808 7078 7082 7067 7075 7079 12803 7068 7076 7080 10286 7069 7972 7077 7081",
	ingredessence  = "11174 10938 11135 11175 16202 11134 16203 10998 11082 10939",
	ingredflux     = "2880 3466 18567",
	ingredgem      = "12799 818 12800 11382 1206 774 1705 1210 12361 9262 1529 12363 11754 12364 7910 3864 19774 7909",
	ingredgrinding = "3470 3478 7966 12644 3486",
	ingredhide     = "4236 4231 4233 15407 8172 4461 8368 7428 783 4235 8171 4232 8169",
	ingredleather  = "15419 2318 15423 2934 4234 2319 15417 12810 15422 8170 5082 19768 17012 4304 19767",
	ingrednexus    = "20725",
	ingredoil      = "6371 6370 3829 9061 3824 13423 8956",
	ingredore      = "2775 2776 18562 2770 3858 2771 11370 2772 7911 10620",
	ingredpart     = "4361 10560 4404 10576 10561 15994 10546 10647 7191 4363 4394 10648 18631 4359 9060 4400 4371 4375 10507 16000 4387 4399 16006 10558 4382 4407 4389 10559 10586",
	ingredpearl    = "5498 4611 13926 5500 7971",
	ingredpoison   = "8924 3818 2928 8923 8925 18256 2930 5173 3372 3371 2931",
	ingredpowder   = "10505 4377 4357 15992 4364",
	ingredrod      = "16206 6338 11144 11128 6217",
	ingredsalt     = "15409 4289 8150",
	ingredscale    = "15408 15412 8165 6471 8167 15414 8154 6470 7286 7392 15415 7287 15416",
	ingredshard    = "11084 14343 11139 10978 11177 14344 11138 11178",
	ingredspice    = "2678 2665 17194 3713 2692",
	ingredstone    = "2835 7912 2836 2838 12365",
	ingredthread   = "2321 14341 4291 2320 8343",
	ingredvial     = "3371 18256 8925 3372",

	-- Tradeskill ingred sources (not including harvestables above)
	ingredmonsterdrops = "15420 1475 17011 3730 3667 3731 5465 1080 5466 5784 5467 5785 5468 5469 1081 5470 13926 5471 3164 1288 12662 4589 12037 8146 4337 4655 12804 4402 12809 8151 7072 18512 2251 3172 3712 12184 729 3173 17010 1015 3174 6889 4096 1468 14227 7971 19441 5051 5373 730 7974 5498 12204 12205 12206 4611 12208 8168 769 9260 12203 5503 2672 5504 723 731 2673 2675 19943 17203 3182 5635 8152 18240 12607 5637 12202 3685 12223 19726 2924 2886 2677 15410 5116 10285 12753 2674 3404 5500 6470 12207 814 12811",
	ingredvendorbought = "8923 4289 8924 8925 9210 4291 8150 11291 1179 6261 4340 2320 4341 2596 2604 4342 159 2880 2321 3857 18567 4470 2692 18256 8343 5173 2894 2665 2928 2605 4536 6530 10647 2930 10648 3713 17194 2324 3466 6260 2678 14341 3372 15409 17196 2325 4400 10290 3371",

	-- All recipes
	recipe = {"recipevendor", "recipedrop", "recipequest", "recipecrafted"},
	recipealchemy = {"recipevendoralchemy", "recipedropalchemy", "recipequestalchemy", "recipecraftedalchemy"},
	recipeblacksmith = {"recipevendorblacksmith", "recipedropblacksmith", "recipequestblacksmith", "recipecraftedblacksmith"},
	recipecooking = {"recipevendorcooking", "recipedropcooking", "recipequestcooking"},
	recipeenchanting = {"recipevendorenchanting", "recipedropenchanting"},
	recipeengineering = {"recipevendorengineering", "recipedropengineering", "recipequestengineering"},
	recipefishing = {"recipevendorfishing"},
	recipefirstaid = {"recipevendorfirstaid", "recipedropfirstaid"},
	recipeleatherworking = {"recipevendorleatherworking", "recipedropleatherworking", "recipequestleatherworking"},
	recipetailoring = {"recipevendortailoring", "recipedroptailoring", "recipequesttailoring"},

	-- Recipes sold by a vendor, somewhere
	-- Value = vendor price
	recipevendor = {"recipevendoralchemy", "recipevendorblacksmith", "recipevendorcooking", "recipevendorenchanting", "recipevendorengineering", "recipevendorfishing", "recipevendorfirstaid", "recipevendorleatherworking", "recipevendortailoring"},
	recipevendoralchemy = "13477:12000 13478:13000 5640:100 5642:1800 5643:2000 6053:800 6055:1500 6056:2000 6057:2000 9300:10000 9301:10000 9302:9000 6068:1500 6054:900 14634:2500 13480:15000 9303:8000 12958:50000 9304:8000 9305:8000 13501:30000 13483:15000 13482:15000 13484:15000 13485:15000 20013:50000 20011:50000 20014:50000 20012:50000 20761:120000",
	recipevendorblacksmith = "12162:3000 12164:4400 7995:6000 10858:3000 6047:4400 12163:4400 19208:70000 19209:70000 19211:120000 19210:120000 19212:120000 17051:70000 17060:220000 19207:80000 19206:60000 17052:180000 17059:220000 20040:80000 17049:90000 17053:200000 19202:22000 19204:40000 19203:22000 19205:40000 19781:50000 19780:50000 19779:50000 19778:50000 19777:50000 19776:50000 22219:50000 22221:80000 22209:50000 22214:50000 22768:50000 22766:50000 22767:50000 8030:10000 12823:20000 12819:16000 12703:40000",
	recipevendorcooking = "16072:10000 13949:20000 4609:1000 2889:240 3734:1600 3679:400 6325:40 6330:1200 5528:800 2698:400 3681:1600 3678:400 3682:1600 12239:7000 5485:400 3683:1600 2697:400 12240:7000 20075:2000 3735:1800 12229:5000 12231:3000 5489:1200 13947:20000 6329:400 6328:400 13948:20000 17062:2200 3680:1600 12233:3000 6368:400 2699:800 12228:5000 6369:2200 2701:1600 6326:40 6892:250 16111:12000 2700:400 18046:12000 728:200 12226:25 5488:400 5484:240 5483:140 5486:440 12232:5000 13940:16000 13941:16000 6039:5000 13942:16000 13943:16000 12227:1600 16110:12000 13945:20000 13946:20000 13939:16000 16767:3000 21099:500 21219:5000 17201:240 17200:25 18160:200",
	recipevendorenchanting = "6349:500 11223:5800 11163:3000 11101:2500 6342:300 11039:800 16217:12000 6377:1000 6346:400 16221:16000 16224:20000 16243:22000 20758:500 20752:3000 20753:4000 20754:10000 20755:20000 19449:100000 19448:80000 19444:30000 19445:30000 19447:60000 19446:30000 20756:40000 20757:40000 20732:90000 20733:90000 22392:25000",
	recipevendorengineering = "18649:1800 10607:3600 7560:1200 13309:1000 14639:1500 10609:4000 16041:12000 16042:12000 18647:1800 13310:2000 10602:3000 16050:20000 7742:2400 7561:2000 18648:1800 18652:12000 13308:1800 16046:16000 13311:10000 18656:16000 16047:16000 18651:12000 20001:50000 20000:50000 19027:5000 18650:5000",
	recipevendorfishing = "16083:10000",
	recipevendorfirstaid = "16084:10000 16112:2200 16113:5000 19442:100000",
	recipevendorleatherworking = "18949:2000 5973:650 7289:650 20576:350 15751:20000 15729:12000 7613:2000 7451:2800 18731:2000 7361:1800 15735:14000 15734:14000 5786:550 5787:600 5789:2800 8409:4000 13288:2500 7290:1600 15741:16000 5788:650 8385:3500 15725:12000 13287:2500 6474:550 6475:1500 15758:22000 7362:2000 15740:16000 14635:3000 15726:12000 15724:12000 15762:25000 15756:22000 18239:3500 17025:160000 19331:90000 19332:90000 17022:150000 19330:60000 19333:90000 17023:160000 20253:16000 20254:20000 19327:40000 19326:22000 19328:22000 19329:40000 19771:50000 19773:50000 19770:50000 19772:50000 19769:50000 20382:60000 20506:40000 20507:40000 20508:40000 20509:40000 20510:40000 20511:40000 22769:50000 22770:50000 22771:50000 15759:22000",
	recipevendortailoring = "7089:1500 7114:1000 6272:300 6270:200 6274:400 14627:800 6401:1100 6275:800 4355:1500 10314:4000 10311:3000 10317:4000 5771:200 5772:500 10326:5000 10323:4500 10321:4500 10325:10000 10318:7000 10728:1500 7087:1200 7088:5000 14630:1000 14483:16000 14526:20000 14468:12000 14488:12000 14472:12000 14481:16000 14469:12000 21358:12000 18487:40000 17018:80000 19220:90000 17017:180000 19219:60000 19215:22000 19218:40000 19216:22000 19217:40000 19766:50000 19765:50000 19764:50000 22310:20000 22312:50000 22307:6000 22308:20000 22683:90000 22773:50000 22772:50000 22774:50000",

	-- Dropped recipes (recipes that are only available as drops)
	recipedrop = {"recipedropalchemy", "recipedropblacksmith", "recipedropcooking", "recipedropenchanting", "recipedropengineering", "recipedropfirstaid", "recipedropleatherworking", "recipedroptailoring" },
	recipedropalchemy = "13481 3832 9297 3830 17709 6663 9298 21547 3396 2553 6211 3394 13491 13479 13522 13520 13518 13521 13519 9296 13493 13497 13494 13495 13496 13499 13490 9295 3395 9293 18257 13476 3831 3393 13492 2555 13489 13488 13486 13487 9294",
	recipedropblacksmith = "12835 12834 12838 22220 7992 12830 11614 11612 11610 11615 11611 7993 2883 8030 17706 18264 3868 12836 3610 7192 3867 3875 3873 3872 3871 3611 3612 3870 12833 12839 7990 7975 12716 12823 12728 5543 6045 6044 3866 12717 12837 3608 7991 7976 7989 12819 22390 3874 12685 12697 12689 12702 12695 12713 2881 8028 12718 12707 12714 12719 12706 22389 12261 12827 3869 5578 10424 2882 6046 12703 12720 22222 12682 12683 12693 12684 12694 12704 12692 22388 12828 12711 8029 12691",
	recipedropfirstaid = "19442",
	recipedropcooking = "18267 6661 2700",
	recipedropenchanting = "11038 16249 16255 16247 16245 16215 11167 16220 16214 11204 11225 6375 6344 6347 16218 16251 16246 16253 16242 20736 16216 11206 11098 20734 20735 11205 11203 20729 20728 16219 16244 20730 11151 11150 11226 20727 11166 20731 20726 11152 11224 11168 11081 11202 16222 16252 11208 11207 18260 16223 11164 11165 16254 6348 18259 16250 16248 17725 11813",
	recipedropengineering = "16055 16054 18290 21730 10601 10603 18292 4415 16049 16048 4413 6716 4411 6672 16056 18291 18654 18653 4416 21731 18657 21727 21733 21728 21734 21729 21735 4417 16044 11827 18655 16053 4408 10604 4412 10606 11828 4414 21732 4410 21724 21725 21726 4409 10608 17720 10605 16045 16043 16051 18658 16052 18661",
	recipedropleatherworking = "4301 18949 4297 5973 8390 8387 8389 8386 15781 15770 7289 20576 15751 15763 15737 15729 15746 15755 18517 8384 18252 7360 4296 2409 15772 7452 7449 2406 2408 5972 15761 15747 15779 18514 17722 15733 7613 7450 7451 4299 4298 5974 4300 7364 18731 15743 15738 15748 15774 15727 7361 18518 4294 4293 15760 15735 15771 15752 15734 18515 5786 5789 5787 8409 7363 13288 15730 7290 7288 15776 15745 15739 15731 15765 15777 18519 15753 21548 15741 15764 7453 18516 5788 8399 8397 8395 8398 8402 8401 8400 15749 15732 15775 2407 15773 15768 15728 15744 15757 15742 15754",
	recipedroptailoring = "7085 18414 22309 5775 4352 14510 14484 14479 14494 14478 14482 14476 14490 14471 14486 18418 10316 21371 7084 7086 14492 18415 14496 14506 14508 18265 14474 14489 14467 14466 14473 14477 14495 14480 14511 2601 7090 5774 4292 7092 4346 18416 14499 14509 18417 14497 14507 14501 4348 4349 2598 6271 10312 10320 10302 10315 10300 4345 4347 4354 14493 14513 14514 5773 14498 14491 14504 14470 4351 4353 4350 4356 6390 6391 7091 14512 10301 14485 14500 14505",

	-- Quested recipes
	recipequest = {"recipequestalchemy", "recipequestblacksmith", "recipequestcooking", "recipequestengineering", "recipequestleatherworking", "recipequesttailoring" },
	recipequestalchemy = "4597 4624",
	recipequestblacksmith = "7979 12727 12726 12725 6735 7980 12699 12700 12690 12705 12701 12715 12687 3609 7985 7981 7978 7982 9367 7983 7984 12688 18592 20554 20553 20555 12696 12825 12824 12821",
	recipequestcooking = "18160 2889 5487 5486 5482 3737 2889 5486 2697 3679 728 3678 3680 2699 2701 3683 3734 3681 3735 3682 3736 4609 21025",
	recipequestengineering = "21738 21737",
	recipequestleatherworking = "8408 6710 8404 8403 8405 8406 8407 5083 6476",
	recipequesttailoring = "10463 17724 21722 21723 20548 20547 20546",

	-- Crated recipes.
	recipecrafted = { "recipecraftedalchemy", "recipecraftedblacksmith" },
	recipecraftedalchemy = "10644",
	recipecraftedblacksmith = "10713",

	recipeseasonal = "17200 17201",

	-- Recipes that require faction to purchase (Same recipes as recipevendor, but other grouping and values)
	-- Value = Reputation index of:
	-- {"Hated", "Hostile", "Unfirendly", "Neutral", "Friendly", "Honored", "Revered", "Exalted"}
	recipefaction = {"recipefactionalliance", "recipefactionhorde", "recipefactionneutral", "recipefactionargentdawn", "recipefactioncenarioncircle", "recipefactionthoriumbrotherhood", "recipefactiontimbermaw", "recipefactionzandalar", "recipefactionravenholdt"},
	recipefactionalliance = "7361 16113 12231 6349 10858 5489 21219 10607 21099 10609 728 16072 7560 5973 3734 2889 16111 3679 6326 2701 5786 13288 5787 16084 5788 12228 5789 2699 13947 16217 20752 12233 17200 20758 3680 16110 17062 13948 12162 8385 6329 6368 13309 6369 15725 6053 13949 7451 15729 6055 16112 6056 5485 6057 15735 12229 12240 18649 6401 6330 15741 3681 2697 12239 3678 3682 2698 5528 20576 3683 15751 18731 6892 18046 2700 4609 22307 11163 4355 10321 18949 6325 13477 13478 10326 7089 7114 6328 10317 14627 10314 10311 5643 20753 8409 17201 9300 9301 6270 9302 6274 14639 6272 10323 7289 10325 16041 16042 5640 11101 6275 11039 5642 15734 11223 6342 5771 7613 5772 7995 7290 19027",
	recipefactionhorde = "6346 6349 10858 7114 16072 5973 5786 5787 16084 5788 16217 20752 17200 20758 5486 12162 16112 12164 6368 21219 6369 21099 15725 6053 13949 7451 16110 6055 5484 16113 16111 6057 11163 20075 18647 11039 6377 6326 15741 5483 12228 13287 13948 3682 5643 13947 12231 10314 8385 3735 6892 12240 6401 6068 12239 5488 4355 12226 18949 6325 13477 13478 12232 7089 6330 6328 9301 17062 9302 10311 6274 20753 8409 17201 9300 10317 6270 6054 18731 10321 6272 10323 12229 10325 16041 16042 22307 15734 7995 10326 5642 6275 11223 6342 5771 7613 5772 11101 5640",
	recipefactionneutral = "5640 5642 5643 16110 13309 13311 20754 20758 3735 14634 9303 9305 10602 7742 16224 6474 6475 13943 13945 12164 15740 14469 15758 15762 20755 7362 16083 13483 13485 15726 22308 16767 16047 13946 13501 12228 13939 12232 6369 6368 18046 5489 12231 10728 17062 12240 6275 15756 14488 13941 22696 18239 5772 6330 3734 7560 7561 13308 13310 18656 4609 21358 14481 14472 6039 14635 6047 20752 18487 6053 6056 6057 14483 14630 7088 7087 6272 10318 6068 22307 9304 21099 10858 16221 6342 22697 5788 13940 13942 5789 16243 15724 7451 7613 21219 14468 22698 15759 20753 18648 18652 13480 6377 16046 16050 12227 12229 14526 12233 12239 12162 12163 6401 18651 12958 12703 8030 12823 12819 18650",
	recipefactionargentdawn = "13482:6 19203:6 19205:7 19216:6 19217:7 19328:6 19329:7 19442:6 19446:6 19447:7",
	recipefactioncenarioncircle = "22219:7 22221:8 22209:5 22214:6 22766:7 22767:6 22768:5 20382:8 20506:5 20507:6 20508:7 20509:5 20510:6 20511:7 22769:5 22770:6 22771:7 20732:5 20733:6 22310:5 22312:7 22683:7 22772:5 22773:6 22774:7",
	recipefactionthoriumbrotherhood = "17051:5 20761:5 17018:5 17023:5 17022:5 19444:5 17059:6 17060:6 19206:6 17049:6 17017:6 19219:6 19330:6 17025:6 19448:6 19208:7 19209:7 17053:7 19207:7 17052:7 19220:7 19333:7 19332:7 19331:7 19449:7 19211:8 19212:8 19210:8 20040:8",
	recipefactiontimbermaw = "13484:5 19202:6 19326:6 19215:6 19445:6 20253:5 19218:7 20254:5 19204:7 19327:7 22392:5",
	recipefactionzandalar = "19764:7 19765:6 19766:5 19769:7 19770:6 19771:5 19772:7 19773:7 19776:7 19777:6 19778:5 19779:7 19780:6 19781:5 20000:6 20001:5 20011:7 20012:5 20013:8 20014:6 20756:6 20757:5",
	recipefactionravenholdt = "18160:4",

	--ingreds used by tradeskills
	tradeskill               = {"tradeskillalchemy", "tradeskillblacksmithing", "tradeskillcooking", "tradeskillenchanting", "tradeskillengineering", "tradeskillfirstaid", "tradeskillleatherworking", "tradeskilltailoring", "tradeskillpoison", "tradeskillsmelting"},
	tradeskillalchemy        = "3824 765 3858 8831 8836 3860 8839 3575 10620 6358 8845 8846 3164 1288 13422 13423 3356 3357 3358 7067 12803 6370 4402 6371 7070 12808 18256 4342 8153 9260 9262 7076 7078 10286 785 13463 13464 13465 7082 13467 13468 2447 3369 2449 2450 3371 6522 3372 3355 5635 8925 7972 3818 2453 8838 11176 3819 7069 12359 2452 3820 15410 12363 5637 3821 4625 7080 9149 13466 118 6359 7068",
	tradeskillblacksmithing  = "15417 12753 20520 20725 13510 13512 22203 22202 3823 5966 2840 17011 2841 1206 2842 11371 3859 6037 3860 14047 3575 11382 3576 2592 19726 3577 12662 3864 2880 1210 12799 8146 7067 3486 4338 7069 7070 19774 1529 12810 12811 8153 7075 7076 1705 7966 17010 17012 7080 2459 7081 2318 7971 774 7972 7909 2605 7910 11186 5498 11188 7912 12809 5500 12655 8168 2589 3478 818 8170 3470 3466 2319 12804 3391 12808 12803 17203 7068 5635 12359 4234 2321 5637 4304 12644 11185 2835 4306 12360 12361 2836 3829 12364 12365 11184 7077 12800 7078 2838 3824 4255",
	tradeskillcooking        = "3730 3667 3731 6289 5465 1080 5466 5467 5468 5469 1081 5470 5471 6361 6362 17196 6303 12037 2692 4655 4402 6308 8365 2251 3172 4536 729 3173 3713 1015 3174 6889 1468 5051 12202 769 730 3685 12203 12204 12205 2924 12207 12208 13758 12206 2886 4603 5503 2672 5504 723 731 2673 6522 6317 3404 2674 12223 13889 7974 2675 17194 2678 2665 13754 13755 13756 6291 2677 13759 13760 13888 3821 2894 1179 2452 13893 159 12184 2596",
	tradeskillenchanting     = "7082 20725 11128 7077 14343 16202 14344 16203 16204 7079 12803 11134 16206 11135 10978 13467 6217 7081 8838 11138 12808 11139 11174 11291 7067 4470 12811 8153 7068 5500 11175 11144 11176 11082 11177 11083 11178 11084 10939 12359 7909 1210 9224 2772 5637 6371 7392 11382 6370 7971 6338 13926 6037 7972 10998 3356 7075 3829 8170 10940 10938 11137",
	tradeskillengineering    = "15407 7079 4377 2840 17011 2841 4382 2842 11371 12655 4371 3859 4375 6037 9060 3860 159 14047 3575 4389 4359 2589 3576 2592 19726 4387 3577 17010 10502 4394 10586 10505 17202 10507 12803 7191 2836 1210 3829 4399 12800 4400 4337 7068 4338 4402 7387 10648 12808 4404 8151 4385 12359 18631 8153 4407 10561 7075 10026 7076 1705 7077 10592 7078 7069 16000 10286 7080 1206 10543 14227 7082 10546 7972 7909 1529 7910 16006 3864 774 7912 12804 4357 12799 10558 10559 10560 818 8170 4361 4234 4339 19774 4611 4363 8150 4364 10285 13467 2318 2319 12810 10576 4304 4368 10500 2835 4306 12360 12361 6530 9061 12364 12365 15992 2880 15994 814 2838 7067 10647",
	tradeskillfirstaid       = "4306 2589 14047 1475 1288 2592 4338 19441",
	tradeskillleatherworking = "12753 2934 15422 15423 3824 2459 17011 7428 1206 5082 11754 3383 14044 5784 8951 14047 14048 15419 4236 6470 18240 3390 19726 15414 8171 4338 8343 8170 8169 3356 1529 15408 14341 783 4461 1210 7286 12809 8146 7067 4337 12803 12804 19768 2312 7070 8150 7071 12810 8152 8368 8153 8167 8154 7075 14342 7076 7971 7077 8949 7078 17012 7079 2320 7080 4096 8151 14227 7082 5785 4289 2319 2605 5116 4291 5498 4340 2321 8165 5373 8172 8168 2324 4232 3864 4233 19767 4234 15420 4235 7392 5633 4231 2997 3182 2325 14256 7287 12607 5637 4304 2318 4305 18512 15407 4243 15409 15410 17010 15412 3389 4246 15415 15416 15417 2457 6471 5500 20498 20381 20500",
	tradeskilltailoring      = "11137 8831 11040 3824 17011 9210 3827 13468 16203 2589 3383 6037 14047 14048 2592 19726 3577 8343 12662 3864 6048 4589 12800 7067 4337 12803 4338 7069 6371 7070 12808 1529 12810 7072 4342 8153 14341 14342 7076 14344 7077 17010 17012 10285 10286 11176 10290 7971 2319 2605 7910 4291 5498 6261 5500 929 8170 13926 4234 7068 2321 14227 2324 2604 4340 3182 2325 14256 2320 3829 12811 4304 4339 4305 6260 4306 12360 4341 2318 12809 12364 7079 7080 2996 18240 7078 7082 2997 7071",
	tradeskillpoison         = "8924 3818 2928 8923 8925 18256 2930 5173 3372 3371 2931",
	tradeskillsmelting       = "2775 2776 18562 2770 3858 2771 11370 2772 7911 10620 2840 3576 3575 3857",

	-- tools used in the tradeskill
	tradeskilltools      = { "toolsenchanting", "toolsengineering", "toolsblacksmithing", "toolsskinning", "toolsmining", "toolsfishing" },
	toolsenchanting			 = "6218 11130 6339 11145 16207",
	toolsengineering     = "5956 6219",
	toolsblacksmithing   = "5956",
	toolsskinning        = "7005",
	toolsmining          = "2901",
	toolsfishing         = "6256 12225 6366 19970 6367 6365",
}


local lib = {}


-- Return the library's current version
function lib:GetLibraryVersion()
	return vmajor, vminor
end


-- Activate a new instance of this library
function lib:LibActivate(stub, oldLib, oldList)
	self.dataset = t
	t = nil
	PeriodicTableEmbed:GetInstance(coremajor):AddModule(setname, self.dataset, self.memuse)
end

lib.memuse = gcinfo() - mem


--------------------------------
--      Load this bitch!      --
--------------------------------
PeriodicTableEmbed:Register(lib)

